﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Macro.h>
#include <nn/http.h>
#include <nn/http/http_JsonResponse.h>

namespace nn{ namespace npns{

class DeviceTokenHolder;
class ResourceConsumerBase
{
    NN_DISALLOW_COPY(ResourceConsumerBase);
    NN_DISALLOW_MOVE(ResourceConsumerBase);
public:
    static const char* ProductCode;

    ResourceConsumerBase(http::ConnectionBroker& cb, DeviceTokenHolder& dth);
    ~ResourceConsumerBase();

    enum ResultCodeCommon
    {
        ResultCode_Success                          = 0,
        ResultCode_DeviceTokenNotPresent            = 1000,
        ResultCode_DeviceTokenInvalidFormat         = 1001,
        ResultCode_DeviceTokenInvalidEnvironment    = 1002,
        ResultCode_DeviceTokenInvalidSignature      = 1003,
        ResultCode_DeviceTokenInvalidDate           = 1004,
        ResultCode_DeviceTokenExpire                = 1005,
        ResultCode_DeviceTokenInvalidClientId       = 1006,
        ResultCode_ProductCodeNotePresnt            = 1100,
        ResultCode_ProductCodeNoteUndefined         = 1101,
        ResultCode_Unknown                          = 9999,
    };

    // result code 10xx は DeviceToken 作り直し
    static const int ResultCodeRange_DeviceTokenError_Begin = 1000;
    static const int ResultCodeRange_DeviceTokenError_End = 1100;

protected:
    Result SetupRequestHeaders(http::Request* pRequest);
    Result SendRequest(http::Request* pRequest, const http::JsonResponse::ParseRule parseRules[], const int64_t& resultCode);

    http::ConnectionBroker& m_ConnectionBroker;
    DeviceTokenHolder& m_DeviceTokenHolder;
};


}}


