﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/http.h>
#include <nn/npns/detail/npns_InternalTypes.h>

#include "npns_ResourceConsumerBase.h"

namespace nn{ namespace npns{

class JidConsumer : public ResourceConsumerBase
{
    NN_DISALLOW_COPY(JidConsumer);
    NN_DISALLOW_MOVE(JidConsumer);
public:
    enum ResultCode
    {
        ResultCode_DeviceNotFound                   = 2001,
        ResultCode_JidNotFound                      = 2002,
        ResultCode_JidDoesNotMatchWithDevice        = 2003,
        ResultCode_JidPasswordIsNotNull             = 2004,
        ResultCode_UndefinedAccountType             = 2100,
        ResultCode_AccountNotFound                  = 2101,
        ResultCode_TokenNotFound                    = 2102,
    };

    JidConsumer(http::ConnectionBroker& cb, DeviceTokenHolder& dth);
    ~JidConsumer();

    Result Create(Credential* pOut);
    Result Renew(Credential* pOut, const Credential& currentCredential);
    Result Remove(const Credential& currentCredential);

private:

};


}}


