﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/socket.h>
#include <nn/socket/socket_SystemConfig.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/http.h>
#include <nn/ssl.h>
#include <nn/nifm/nifm_ApiForSystem.h>
#include <nn/account.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/account/account_ApiBaasAccessToken.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/npns/detail/npns_Utility.h>
#include <nn/bgtc.h>
#include <mutex>
#include <cstdlib>

#include "npns_Instance.h"
#include "npns_HipcServer.h"
#include "npns_Controller.h"
#include "npns_ClientThread.h"
#include "npns_StateMachineThread.h"
#include "npns_SystemEventHandlerThread.h"
#include "npns_Router.h"
#include "npns_Config.h"

    extern void XmppStanzaLeakTest();
namespace nn{ namespace npns{

namespace
{
    const int SocketCount = 2;
    const int SocketConcurrencyCount = SocketCount;
    nn::socket::SystemConfigLightDefaultWithMemory<SocketCount, 0> g_SocketConfigWithMemory(SocketConcurrencyCount);
    Instance s_Daemon;

    std::aligned_storage<sizeof(IpcServerManager), NN_ALIGNOF(IpcServerManager)>::type s_IpcServerManagerStorage;
    NN_OS_ALIGNAS_THREAD_STACK ClientThread        s_ClientThread;
    Controller s_Controller(s_ClientThread);
    NN_OS_ALIGNAS_THREAD_STACK StateMachineThread  s_StateMachineThread(s_Controller);
    NN_OS_ALIGNAS_THREAD_STACK SystemEventHandlerThread s_SystemEventHandlerThread;
    Router s_Router;
    Statistics s_Statistics;
}

Instance& g_Daemon = s_Daemon;

Instance::Instance()
    : m_ClientThread(s_ClientThread)
    , m_StateMachineThread(s_StateMachineThread)
    , m_Router(s_Router)
    , m_Controller(s_Controller)
    , m_IpcServerManager(* new(&s_IpcServerManagerStorage) IpcServerManager)
    , m_SystemEventHandlerThread(s_SystemEventHandlerThread)
    , m_Statistics(s_Statistics)
{
}

void Instance::Initialize()
{
    XmppStanzaLeakTest();

    // 各種ライブラリの初期化
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        bgtc::Initialize()
    );
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        nifm::InitializeSystem()
    );
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        socket::Initialize(g_SocketConfigWithMemory)
    );
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ssl::Initialize()
    );
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        http::Initialize()
    );

    account::InitializeBaasAccessTokenAccessor();
    account::InitializeForSystemService();

    // 内部モジュールの初期化
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        m_ClientThread.Initialize()
    );
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        m_StateMachineThread.Initialize()
    );
#if !defined(NN_NPNS_TEST_DISABLE_PSC) || NN_NPNS_TEST_DISABLE_PSC == 0
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        m_SystemEventHandlerThread.Initialize()
    );
#endif

#if !NN_NPNS_ENABLE_HIPC
    s_StateMachineThread.RequestChangeStateAsync(State_Connected);
#endif

#if NN_NPNS_ENABLE_HIPC
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        m_IpcServerManager.Initialize()
    );
#endif
}

void Instance::Finalize()
{
#if NN_NPNS_ENABLE_HIPC
    m_IpcServerManager.Finalize();
    m_IpcServerManager.~IpcServerManager(); // static dtor に任せるとメモリの開放が遅れる
#endif

#if !NN_NPNS_ENABLE_HIPC
    StateMachineThread::Request req(State_Exit, ResultCanceledByOtherRequest());
    m_StateMachineThread.SendRequest(req, false);
    req.Wait();
#endif

#if !defined(NN_NPNS_TEST_DISABLE_PSC) || NN_NPNS_TEST_DISABLE_PSC == 0
    m_SystemEventHandlerThread.Finalize();
#endif
    m_StateMachineThread.Finalize();
    m_ClientThread.Finalize();

    //account::FinalizeBaasAccessTokenAccessor();
    http::Finalize();
    ssl::Finalize();
    socket::Finalize();

    //nifm::Finalize();
    bgtc::Finalize();
}

}}
