﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

namespace nn{ namespace npns{

class FunctionTracer
{
public:
    FunctionTracer(int line, const char* file, const char* function, const char* module, nn::diag::LogSeverity serverity);
    ~FunctionTracer();
    void PrintEntering(const char* fmt, ...);
    void PrintLeaving(const char* fmt, ...);

private:
    nn::diag::LogMetaData m_logMetaData;
    bool m_bPrintLeavingRequired;
};

}}
