﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/bgsu/bgsu_ThreadTemplate.h>

#include "npns_Config.h"
#include "npns_Client.h"

namespace nn{ namespace npns{

class ClientThread : public bgsu::ThreadTemplate<ClientThread, NN_NPNS_THREAD_STACK_SIZE_CLIENT>
                   , public Client // Listener の仕組みを作るのが面倒なので
{
public:
    typedef bgsu::ThreadTemplate<ClientThread, NN_NPNS_THREAD_STACK_SIZE_CLIENT> ThreadBase;
    static const int32_t DisconnectionTimeOutInMs = 2500; // DISCONNECT_TIMEOUT + 500ms

    ClientThread();
    Result Initialize();
    void Finalize();

    Result Connect(const char* jid, const char* password);
    void Disconnect();

    os::Event& GetConnectionStateChangedEvent();

    void OnShutdown();

    bool WaitDisconnect();
    bool WaitPendingDataEmpty();

protected:
    virtual void ThreadBody();
    virtual void RequestExit();

    virtual void OnConnected();
    virtual void OnDisconnected();
    virtual void OnReceiveIdle();
    virtual void OnFlush();

private:
    nn::os::Event           m_eventUpdated;
    nn::os::Event           m_eventFlush;
    nn::os::Event           m_eventConnectionStateChanged;
    nn::os::Mutex           m_mutexConnection;
    //Client                  m_client;
};

}}


