﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/service/nifm_ServiceProvider.h>

#include <nn/nn_Log.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/init.h>
#include <nn/os/os_ThreadApi.h>
#include <nn/util/util_TypedStorage.h>


#if defined(NN_BUILD_CONFIG_OS_HORIZON)
namespace nn
{
namespace nifm
{

// TODO: [TORIAEZU] libcurl が使う libnn_nifm 内の関数の代わり
nn::Result GetCurrentProxySetting(nn::nifm::ProxySetting* p)
{
    NN_UNUSED(p);
    NN_RESULT_THROW(ResultNotImplemented());
}

}
}
#endif

namespace
{
    char g_HeapMemory[512 * 1024]; // TODO: curl
    nn::util::TypedStorage<nn::nifm::detail::ServiceProvider, sizeof(nn::nifm::detail::ServiceProvider), NN_ALIGNOF(nn::nifm::detail::ServiceProvider)> g_ServiceProviderStorage;
}

#if defined(NN_DETAIL_NIFM_LOG_UART)
extern "C" void nndiagStartup()
{
}
#endif

extern "C" void nninitStartup()
{
    nn::init::InitializeAllocator(g_HeapMemory, sizeof(g_HeapMemory));
}

extern "C" void nnMain()
{
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(nifm, Main));

    nn::nifm::detail::ServiceProvider* pServiceProvider = new(&g_ServiceProviderStorage) nn::nifm::detail::ServiceProvider;
    pServiceProvider->Start();
}
