﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/init.h>
#include <nn/nn_Common.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/eupld/server/eupld_ServerApi.h>

namespace nn    {
namespace eupld {
namespace       {

const size_t UploaderMemoryPoolSize = (128 * 1024);
const size_t CurlMemoryPoolSize     = (896 * 1024);
NN_ALIGNAS(4096) uint8_t g_UploaderMemory[UploaderMemoryPoolSize];
NN_ALIGNAS(4096) uint8_t g_CurlMemory[CurlMemoryPoolSize];

}}}

extern "C" void nninitStartup()
{
    nn::init::InitializeAllocator(reinterpret_cast<void*>(nn::eupld::g_CurlMemory), sizeof(nn::eupld::g_CurlMemory));
}

extern "C" void nndiagStartup()
{

}

extern "C" void nnMain()
{
    const char SettingName[] = "eupld";
    const char SettingKey[]  = "upload_enabled";
    const char ServerUrl[]   = "https://receive-%.er.srv.nintendo.net/post";
    bool  uploadEnabled      = false;

    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(eupld, Main));

    nn::Result result = nn::eupld::srv::Initialize(nn::eupld::g_UploaderMemory, sizeof(nn::eupld::g_UploaderMemory));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    if (nn::settings::fwdbg::GetSettingsItemValue(
            &uploadEnabled,
            sizeof(uploadEnabled),
            SettingName,
            SettingKey) == sizeof(uploadEnabled) && uploadEnabled)
    {
        result = nn::eupld::srv::SetUrl(ServerUrl, sizeof(ServerUrl));
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    nn::eupld::srv::Wait();
}
