﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "creport_Common.h"

namespace nn { namespace creport {

    class ModuleManager
    {
    public:
        ModuleManager() NN_NOEXCEPT : m_DebugHandle(svc::INVALID_HANDLE_VALUE), m_ModuleCount(0)
        {
            std::memset(m_Module, 0, sizeof(m_Module));
        }

        void CollectModuleInformation(svc::Handle handle, uintptr_t regPc, uintptr_t regLr) NN_NOEXCEPT;

        void AppendToBuffer(InfoBuffer* pOutBuffer) NN_NOEXCEPT;

        Bit64 GetOffset(uintptr_t addr) const NN_NOEXCEPT;

    private:
        bool FindCodeRegionStart(uintptr_t* startAddress, uintptr_t hint) NN_NOEXCEPT;
        void GetModuleName(char* pOutModuleName, size_t moduleNameSize, uintptr_t roStart) NN_NOEXCEPT;
        void GetModuleId(Bit8* pOutModuleId, size_t moduleIdSize, uintptr_t roStart) NN_NOEXCEPT;

    private:
        static const int MaxModuleCount      = 16;
        static const int MaxModuleNameLength = 32;
        static const int MaxModuleIdLength   = 32;

        struct ModuleInfo
        {
            char  moduleName[MaxModuleNameLength];
            Bit8  moduleId[MaxModuleIdLength];
            Bit64 codeBase;
            Bit64 codeEnd;
        };

    private:
        svc::Handle m_DebugHandle;

        Bit8        m_ModuleCount;
        ModuleInfo  m_Module[MaxModuleCount];
    };

}}
