﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/gpio/driver/gpio.h>
#include <nn/gpio/driver/gpio_PadAccessorDev.h>

namespace {
    enum {
        GpioEnableFanPower = 36,
        GpioEnableFanPwm = 39,
    };
}

namespace nn { namespace boot {

void SetFanPowerEnabled() NN_NOEXCEPT
{
    nn::gpio::driver::GpioPadSession sessionForPower;
    nn::gpio::driver::GpioPadSession sessionForPwm;

    // TORIAEZU : Initialize() を呼ぶと割り込み用のスレッドを回してしまうので呼ばない
    // ドライバの動作には影響はない
    //nn::gpio::driver::Initialize();

    nn::gpio::driver::OpenSessionForDev(&sessionForPower, GpioEnableFanPower);
    nn::gpio::driver::OpenSessionForDev(&sessionForPwm, GpioEnableFanPwm);

    nn::gpio::driver::SetDirection(&sessionForPower, nn::gpio::Direction_Output);

    // pinmux の操作を目的とした処置です
    // GPIO 内部で pinmux が設定されることによって FAN が回ります
    nn::gpio::driver::SetDirection(&sessionForPwm, nn::gpio::Direction_Output);

    nn::gpio::driver::SetValue(&sessionForPower, nn::gpio::GpioValue_High);

    nn::gpio::driver::CloseSession(&sessionForPower);
    nn::gpio::driver::CloseSession(&sessionForPwm);

    //nn::gpio::driver::Finalize();
}

}}  // namespace nn::boot
