﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief
 */
#include <nn/bluetooth/bluetooth_TypesHal.h>
#include "bluetooth_InternalTypes.h"

//--------------------------------------------------------------------------
//  C/C++
//--------------------------------------------------------------------------

enum {BUFFER_SIZE=1024};

enum {
    HAL_QUEUE_HID = 1,
    HAL_QUEUE_CB,
    HAL_QUEUE_BLE,
    HAL_QUEUE_BLE_CORE,
    HAL_QUEUE_BLE_HID,
};

enum {THREAD_STACK_SIZE=4 * 4096};

#define CallbackTypes \
    X( CALLBACK_TYPE_START ) \
    X( CALLBACK_TYPE_ADAPTER_STATE_CHANGED ) \
    X( CALLBACK_TYPE_ADAPTER_PROPERTIES ) \
    X( CALLBACK_TYPE_REMOTE_DEVICE_PROPERTIES ) \
    X( CALLBACK_TYPE_DEVICE_FOUND ) \
    X( CALLBACK_TYPE_DISCOVER_STATE_CHANGED ) \
    X( CALLBACK_TYPE_PIN_REQUEST ) \
    X( CALLBACK_TYPE_SSP_REQUEST ) \
    X( CALLBACK_TYPE_BOND_STATE_CHANGED ) \
    X( CALLBACK_TYPE_BOND_STATE_AUTHENTICATION_SUCCESS ) \
    X( CALLBACK_TYPE_BOND_STATE_SP_CONFIRMED ) \
    X( CALLBACK_TYPE_BOND_STATE_KEY_NOTIFICATION ) \
    X( CALLBACK_TYPE_BOND_STATE_BONDING ) \
    X( CALLBACK_TYPE_BOND_STATE_RESUMED ) \
    X( CALLBACK_TYPE_BOND_STATE_SUSPENDED ) \
    X( CALLBACK_TYPE_BOND_STATE_CANCELLED ) \
    X( CALLBACK_TYPE_BOND_STATE_AUTHENTICATION_FAILURE ) \
    X( CALLBACK_TYPE_BOND_STATE_AUTHORIZE ) \
    X( CALLBACK_TYPE_ACL_STATE_CHANGED ) \
    X( CALLBACK_TYPE_THREAD_EVENT ) \
    X( CALLBACK_TYPE_DUT_MODE_RECEIVED ) \
    X( CALLBACK_TYPE_LE_TEST_MODE ) \
    X( CALLBACK_TYPE_ENERGY_INFO ) \
    X( CALLBACK_TYPE_CONNECTION_STATE_CONNECTED ) \
    X( CALLBACK_TYPE_CONNECTION_STATE_DISCONNECTED ) \
    X( CALLBACK_TYPE_HID_INFO ) \
    X( CALLBACK_TYPE_PROTOCOL_MODE ) \
    X( CALLBACK_TYPE_IDLE_TIME ) \
    X( CALLBACK_TYPE_GET_REPORT ) \
    X( CALLBACK_TYPE_VIRTUAL_UNPLUG ) \
    X( CALLBACK_TYPE_HANDSHAKE ) \
    X( CALLBACK_TYPE_EXTENSION_SET_TSI ) \
    X( CALLBACK_TYPE_EXTENSION_EXIT_TSI ) \
    X( CALLBACK_TYPE_EXTENSION_SET_BURST ) \
    X( CALLBACK_TYPE_EXTENSION_EXIT_BURST ) \
    X( CALLBACK_TYPE_EXTENSION_SET_ZERO_RETRAN ) \
    X( CALLBACK_TYPE_EXTENSION_GET_PENDING_CONNECTIONS ) \
    X( CALLBACK_TYPE_HID_DATA ) \
    X( CALLBACK_TYPE_SET_REPORT ) \
    X( CALLBACK_TYPE_FATAL_ERROR ) \
    X( CALLBACK_TYPE_LE_CONN_PARAM_UPDATE ) \
    X( CALLBACK_TYPE_LE_CONN_PARAM_UPDATE_REQ) \
    X( CALLBACK_TYPE_LE_SCAN_STATE_CHANGED ) \
    X( CALLBACK_TYPE_LE_SCAN_FILTER_STATE_CHANGED ) \
    X( CALLBACK_TYPE_LE_CLIENT_STATE_CHANGED ) \
    X( CALLBACK_TYPE_LE_CLIENT_CONN_STATE_CHANGED ) \
    X( CALLBACK_TYPE_LE_CLIENT_GATT_OP ) \
    X( CALLBACK_TYPE_LE_CLIENT_GATT_INDICATION_RESPONSE_NEEDED) \
    X( CALLBACK_TYPE_LE_CLIENT_GATT_SERVICE_DISCOVERY ) \
    X( CALLBACK_TYPE_LE_CLIENT_GATT_SERVICE_DISCOVERY_STATE_CHANGED ) \
    X( CALLBACK_TYPE_LE_CLIENT_CONFIGURE_MTU ) \
    X( CALLBACK_TYPE_LE_SERVER_STATE_CHANGED ) \
    X( CALLBACK_TYPE_LE_SERVER_CONN_STATE_CHANGED ) \
    X( CALLBACK_TYPE_LE_SERVER_PROFILE_CHANGED_CALLBACK ) \
    X( CALLBACK_TYPE_LE_SERVER_GATT_REQ_CALLBACK ) \
    X( CALLBACK_TYPE_FINALIZE ) \
    X( CALLBACK_TYPE_END )

enum CallbackType {
#define X(ID) ID,
    CallbackTypes
#undef X
};

int  BluetoothHalInsertToQueue(void *pData, int dataLen, uint8_t type, enum CallbackType cbType);
void BluetoothHalCreateQueue(uint8_t type);
void BluetoothHalDestroyQueue(uint8_t type);

// Function to register with the Bluetooth HAL
void BtHalCallbackHidRegister(BluetoothHhCallbacks* callbacks);
void BtHalCallbackRegisterCore(BluetoothCallbacks* callbacks);
void BtHalCallbackRegisterExtension(BluetoothExtCallbacks* callbacks);
void BtHalCallbackRegisterLowEnergy(BluetoothLeCallbacks* callbacks);

