﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/* for BSA functions and types */
#include "bsa_api.h"
#include "xml_param.h"
#include "bsa_disc_api.h"

typedef struct
{
    tAPP_XML_CONFIG xml_config; /* Local Bluetooth configuration */
    UINT8 display_id;
    UINT8 channels[BTM_AFH_CHNL_MAP_SIZE]; /* channel information pass from controller */
    BOOLEAN wl_aligned; /* WiFi alignment */

    BD_ADDR peer_addr; /* For TSI setting */
    UINT8 tsi_mode; /* For TSI setting */
} tAPP_ROBSON_CB;

/*
 * Global Variables
 */
extern tAPP_ROBSON_CB app_robson_cb;

/* Security custom Callback */
typedef BOOLEAN (tAPP_SEC_CUSTOM_CBACK)(tBSA_SEC_EVT event, tBSA_SEC_MSG *p_data);

typedef enum
{
    APP_SEC_AUTO_PAIR_MODE,
    APP_SEC_MANUAL_PAIR_MODE
} tAPP_SEC_PAIRING_MODE;

typedef struct
{
    BOOLEAN auto_accept_pairing;
    PIN_CODE pin_code; /* PIN Code */
    UINT8 pin_len; /* PIN Length */
    BD_ADDR sec_bd_addr; /* BdAddr of peer device requesting SP */
    tAPP_SEC_CUSTOM_CBACK *sec_custom_cback; /* Application security callback */
    BOOLEAN ssp_debug;
    //tBSA_SEC_AUTH_RESP auth;
} tAPP_SECURITY_CB;

extern tAPP_SECURITY_CB app_sec_cb;

/*******************************************************************************
 **
 ** Function         app_robson_init_xml
 **
 ** Description
 **
 ** Returns          -1 if error, 0 otherwise
 **
 *******************************************************************************/
int app_robson_init_xml();

/*******************************************************************************
 **
 ** Function         app_robson_apply_xml
 **
 ** Description
 **
 ** Returns          -1 if error, 0 otherwise
 **
 *******************************************************************************/
int app_robson_apply_xml();

/*******************************************************************************
 **
 ** Function         app_robson_set_config
 **
 ** Description
 **
 ** Returns          -1 if error, 0 otherwise
 **
 *******************************************************************************/
int app_robson_set_config();

/*******************************************************************************
 **
 ** Function         btHalExtensionCallback
 **
 ** Description
 **
 ** Returns
 **
 *******************************************************************************/
void BtHalCallbackExtension(tBSA_ROBSON_EVT event, tBSA_ROBSON_MSG *p_data);

/*******************************************************************************
 **
 ** Function         btHalSecCback
 **
 ** Description
 **
 ** Returns
 **
 *******************************************************************************/
BOOLEAN BtHalCallbackSecurity(tBSA_SEC_EVT event, tBSA_SEC_MSG *p_data);

/*******************************************************************************
 **
 ** Function         BtHalSet10DbBoost
 **
 ** Description
 **
 ** Returns
 **
 *******************************************************************************/
int BtHalSet10DbBoost();

/*******************************************************************************
 **
 ** Function         BtHalDisableAfh
 **
 ** Description
 **
 ** Returns
 **
 *******************************************************************************/
int BtHalDisableAfh();
