﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <atomic>
#include <mutex>
#include <nn/nn_Macro.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_SdkLog.h>
#include <nn/os/os_Mutex.h>

#ifdef NN_BUILD_CONFIG_OS_HORIZON
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#endif

#include "bluetooth_Settings.h"

namespace nn { namespace bluetooth {

namespace {

struct LockableMutexType final
{
    ::nn::os::MutexType _mutex;

    void lock() NN_NOEXCEPT
    {
        ::nn::os::LockMutex(&_mutex);
    }

    void unlock() NN_NOEXCEPT
    {
        ::nn::os::UnlockMutex(&_mutex);
    }
};

struct FirmwareDebugSettingsValue
{
    bool isSkipBoot;
};

LockableMutexType g_FirmwareDebugSettingsValueMutex =
{
    NN_OS_MUTEX_INITIALIZER(false)
};

FirmwareDebugSettingsValue g_FirmwareDebugSettingsValue;

void InitializeFirmwareDebugSettingsValue() NN_NOEXCEPT;

} // namespace

void FirmwareDebugSettings::Initialize() NN_NOEXCEPT
{
    ::std::lock_guard<decltype(g_FirmwareDebugSettingsValueMutex)
                      > locker(g_FirmwareDebugSettingsValueMutex);

    InitializeFirmwareDebugSettingsValue();
}

bool FirmwareDebugSettings::IsSkipBoot() NN_NOEXCEPT
{
    Initialize();
    return g_FirmwareDebugSettingsValue.isSkipBoot;
}

namespace {

void InitializeFirmwareDebugSettingsValue() NN_NOEXCEPT
{
    const char* const BluetoothDebugSettingsName = "bluetooth_debug";

    g_FirmwareDebugSettingsValue.isSkipBoot = false;

    ::nn::settings::fwdbg::GetSettingsItemValue(
        &g_FirmwareDebugSettingsValue.isSkipBoot,
        sizeof(g_FirmwareDebugSettingsValue.isSkipBoot),
        BluetoothDebugSettingsName, "skip_boot");
}

} // namespace

}} // namespace nn::bluetooth
