﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/nn_Abort.h>
#include <nn/os/os_Thread.h>
#include <nn/am/service/am_AppletService.h>

namespace nn { namespace am { namespace service {

    namespace
    {
        // Event Handler Thread
        nn::os::ThreadType              g_EventHandlerThread;
        NN_OS_ALIGNAS_THREAD_STACK char g_EventHandlerThreadStack[0x4000];
        nn::os::ThreadType              g_WindowManagerThread;
        NN_OS_ALIGNAS_THREAD_STACK char g_WindowManagerThreadStack[0x4000];

        void EventHandlerThread(void* arg) NN_NOEXCEPT
        {
            auto* p = reinterpret_cast<AppletService*>(arg);
            p->EventHandlerLoopAuto();
        }

    }   // anonymous namespace

    void StartAppletManager(AppletService* p) NN_NOEXCEPT
    {
        // アプレットマネージャ内スレッドの生成＆開始
        NN_ABORT_UNLESS_RESULT_SUCCESS( nn::os::CreateThread(
                                            &g_EventHandlerThread,
                                            EventHandlerThread,
                                            p,
                                            g_EventHandlerThreadStack,
                                            sizeof(g_EventHandlerThreadStack),
                                            NN_SYSTEM_THREAD_PRIORITY(am, EventObserver)
                                        ));
        nn::os::StartThread(&g_EventHandlerThread);
    }

    void StartWindowManager(AppletService* p) NN_NOEXCEPT
    {
        auto f = [](void* p_)
        {
            auto pAppletService = reinterpret_cast<AppletService*>(p_);
            pAppletService->RunWindowManager();
        };
        // アプレットマネージャ内スレッドの生成＆開始
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(&g_WindowManagerThread, f, p, g_WindowManagerThreadStack, sizeof(g_WindowManagerThreadStack), NN_SYSTEM_THREAD_PRIORITY(am, WindowSystem)));
        nn::os::StartThread(&g_WindowManagerThread);
    }

}}} // namespace nn::am::service

