﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "dmnt_HtcsReceiveBuffer.h"

namespace nn { namespace dmnt { namespace io {

class DebugServerSession
{
    int m_ListenFd;
public:
    DebugServerSession(): m_ListenFd(-1)
    {
    }

    void Initialize(int port);
    int GetListenFd()
    {
        return m_ListenFd;
    }
    void Finalize();
};

class DebugSession
{
public:
    explicit DebugSession(int fd);
    ~DebugSession();
    int RecvPoll(int);
    int RecvPoll()
    {
        return RecvPoll(-1);
    }
    int GetDebugChar();
    int PutDebugChar(int c);
    int PutDebugString(const char* pString);
    bool IsValid()
    {
        return m_Valid;
    }
    void HtcsRecvLoop();
private:
    nn::os::ThreadType m_ReceiveThread;
    void* m_pReceiveThreadStack;
    HtcsReceiveBuffer m_HtcsReceiveBuffer;

    int m_ClientFd;
    bool m_Valid;
};

}}}
