﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/fs.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/nn_Assert.h>
#include <nn/os/os_Mutex.h>

#include "dmnt_Allocator.h"

using namespace nn::lmem;

namespace nn { namespace dmnt { namespace alloc {

namespace {
HeapHandle g_HeapHandle;
const size_t HeapSize = 256 * 1024;
char       g_Heap[HeapSize];

void InitializeHeap()
{
    g_HeapHandle = CreateExpHeap(g_Heap, HeapSize, CreationOption_ThreadSafe);
    NN_ASSERT_NOT_NULL(g_HeapHandle);
}
} // namespace

void* Allocate(size_t size)
{
    return AllocateFromExpHeap(g_HeapHandle, size);
}

void* AllocateStack(size_t size)
{
    return AllocateFromExpHeap(g_HeapHandle, size, nn::os::StackRegionAlignment);
}

void Deallocate(void* p)
{
    return FreeToExpHeap(g_HeapHandle, p);
}

void Deallocate(void* p, size_t size)
{
    NN_UNUSED(size);
    return FreeToExpHeap(g_HeapHandle, p);
}


void Initialize()
{
    InitializeHeap();
}

}}}
