﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "xcd_VibrationAmFmCommand.h"

namespace nn { namespace xcd {

const VibrationAmFmCommand::AmFmCommand VibrationAmFmCommand::s_Table5bitVer1[] = {
    { AmFmAction::Reset,    AmFmAction::Reset,    VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.0f)      },   //!< 0x00 (00)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.0f)      },   //!< 0x01 (01)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-0.5f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x02 (02)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-1.0f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x03 (03)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-1.5f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x04 (04)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-2.0f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x05 (05)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-2.5f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x06 (06)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-3.0f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x07 (07)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-3.5f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x08 (08)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-4.0f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x09 (09)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-4.5f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x0A (10)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-5.0f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x0B (11)
    { AmFmAction::None,     AmFmAction::Set,      VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(-0.5f)     },   //!< 0x0C (12)
    { AmFmAction::None,     AmFmAction::Set,      VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(-0.25f)    },   //!< 0x0D (13)
    { AmFmAction::None,     AmFmAction::Set,      VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.00f)     },   //!< 0x0E (14)
    { AmFmAction::None,     AmFmAction::Set,      VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.25f)     },   //!< 0x0F (15)
    { AmFmAction::None,     AmFmAction::Set,      VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.5f)      },   //!< 0x10 (16)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(0.3125f),   VibrationLogT::FromFloat(0.0625f)   },   //!< 0x11 (17)
    { AmFmAction::Multiply, AmFmAction::None,     VibrationLogT::FromFloat(0.3125f),   VibrationLogT::FromFloat(0.0f)      },   //!< 0x12 (18)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(0.3125f),   VibrationLogT::FromFloat(-0.0625f)  },   //!< 0x13 (19)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(0.09375f),  VibrationLogT::FromFloat(0.0625f)   },   //!< 0x14 (20)
    { AmFmAction::Multiply, AmFmAction::None,     VibrationLogT::FromFloat(0.09375f),  VibrationLogT::FromFloat(0.0f)      },   //!< 0x15 (21)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(0.09375f),  VibrationLogT::FromFloat(-0.0625f)  },   //!< 0x16 (22)
    { AmFmAction::None,     AmFmAction::Multiply, VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.0625f)   },   //!< 0x17 (23)
    { AmFmAction::None,     AmFmAction::None,     VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.0f)      },   //!< 0x18 (24)
    { AmFmAction::None,     AmFmAction::Multiply, VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(-0.0625f)  },   //!< 0x19 (25)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(-0.09375f), VibrationLogT::FromFloat(0.0625f)   },   //!< 0x1A (26)
    { AmFmAction::Multiply, AmFmAction::None,     VibrationLogT::FromFloat(-0.09375f), VibrationLogT::FromFloat(0.0f)      },   //!< 0x1B (27)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(-0.09375f), VibrationLogT::FromFloat(-0.0625f)  },   //!< 0x1C (28)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(-0.3125f),  VibrationLogT::FromFloat(0.0625f)   },   //!< 0x1D (29)
    { AmFmAction::Multiply, AmFmAction::None,     VibrationLogT::FromFloat(-0.3125f),  VibrationLogT::FromFloat(0.0f)      },   //!< 0x1E (30)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(-0.3125f),  VibrationLogT::FromFloat(-0.0625f)  },   //!< 0x1F (31)
};

const VibrationAmFmCommand::AmFmCommand VibrationAmFmCommand::s_Table5bitVer2[] = {
    { AmFmAction::Reset,    AmFmAction::Reset,    VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.0f)      },   //!< 0x00 (00)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.0f)      },   //!< 0x01 (01)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-0.5f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x02 (02)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-1.0f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x03 (03)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-1.5f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x04 (04)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-2.0f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x05 (05)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-2.5f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x06 (06)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-3.0f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x07 (07)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-3.5f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x08 (08)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-4.0f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x09 (09)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-4.5f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x0A (10)
    { AmFmAction::Set,      AmFmAction::None,     VibrationLogT::FromFloat(-5.0f),     VibrationLogT::FromFloat(0.0f)      },   //!< 0x0B (11)
    { AmFmAction::None,     AmFmAction::Set,      VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(-0.375f)   },   //!< 0x0C (12)
    { AmFmAction::None,     AmFmAction::Set,      VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(-0.1875f)  },   //!< 0x0D (13)
    { AmFmAction::None,     AmFmAction::Set,      VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.00f)     },   //!< 0x0E (14)
    { AmFmAction::None,     AmFmAction::Set,      VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.1875f)   },   //!< 0x0F (15)
    { AmFmAction::None,     AmFmAction::Set,      VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.375f)    },   //!< 0x10 (16)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(0.125f),    VibrationLogT::FromFloat(0.03125f)  },   //!< 0x11 (17)
    { AmFmAction::Multiply, AmFmAction::None,     VibrationLogT::FromFloat(0.125f),    VibrationLogT::FromFloat(0.0f)      },   //!< 0x12 (18)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(0.125f),    VibrationLogT::FromFloat(-0.03125f) },   //!< 0x13 (19)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(0.03125f),  VibrationLogT::FromFloat(0.03125f)  },   //!< 0x14 (20)
    { AmFmAction::Multiply, AmFmAction::None,     VibrationLogT::FromFloat(0.03125f),  VibrationLogT::FromFloat(0.0f)      },   //!< 0x15 (21)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(0.03125f),  VibrationLogT::FromFloat(-0.03125f) },   //!< 0x16 (22)
    { AmFmAction::None,     AmFmAction::Multiply, VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.03125f)  },   //!< 0x17 (23)
    { AmFmAction::None,     AmFmAction::None,     VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(0.0f)      },   //!< 0x18 (24)
    { AmFmAction::None,     AmFmAction::Multiply, VibrationLogT::FromFloat(0.0f),      VibrationLogT::FromFloat(-0.03125f) },   //!< 0x19 (25)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(-0.03125f), VibrationLogT::FromFloat(0.03125f)  },   //!< 0x1A (26)
    { AmFmAction::Multiply, AmFmAction::None,     VibrationLogT::FromFloat(-0.03125f), VibrationLogT::FromFloat(0.0f)      },   //!< 0x1B (27)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(-0.03125f), VibrationLogT::FromFloat(-0.03125f) },   //!< 0x1C (28)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(-0.125f),   VibrationLogT::FromFloat(0.03125f)  },   //!< 0x1D (29)
    { AmFmAction::Multiply, AmFmAction::None,     VibrationLogT::FromFloat(-0.125f),   VibrationLogT::FromFloat(0.0f)      },   //!< 0x1E (30)
    { AmFmAction::Multiply, AmFmAction::Multiply, VibrationLogT::FromFloat(-0.125f),   VibrationLogT::FromFloat(-0.03125f) },   //!< 0x1F (31)
};

const VibrationAmFmCommand::Config VibrationAmFmCommand::s_Config5bitVer1 = {
    VibrationLogT::FromFloat(-12.0f),       //!< logResetAmp
    VibrationLogT::FromFloat(-12.0f),       //!< logMinAmp
    VibrationLogT::FromFloat(0.0f),         //!< logMaxAmp
    VibrationLogT::FromFloat(-11.5f),       //!< logZeroAmp
    VibrationLogT::FromFloat(0.0f),         //!< logResetFreq
    VibrationLogT::FromFloat(-2.0f),        //!< logMinFreq
    VibrationLogT::FromFloat(2.0f),         //!< logMaxFreq
    VibrationAmFmCommand::s_Table5bitVer1   //!< pTable
};

const VibrationAmFmCommand::Config VibrationAmFmCommand::s_Config5bitVer2 = {
    VibrationLogT::FromFloat(-8.0f),        //!< logResetAmp
    VibrationLogT::FromFloat(-8.0f),        //!< logMinAmp
    VibrationLogT::FromFloat(0.0f),         //!< logMaxAmp
    VibrationLogT::FromFloat(-7.9375f),     //!< logZeroAmp
    VibrationLogT::FromFloat(0.0f),         //!< logResetFreq
    VibrationLogT::FromFloat(-2.0f),        //!< logMinFreq
    VibrationLogT::FromFloat(2.0f),         //!< logMaxFreq
    VibrationAmFmCommand::s_Table5bitVer2   //!< pTable
};

}} // namespace nn::xcd
