﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/xcd/xcd_VibrationAmFmCodec.h>
#include "xcd_VibrationAmFmDecoder.h"
#include "xcd_VibrationAmFmEncoder.h"

namespace nn { namespace xcd {

void ResetVibrationAmFmDecoderContext(
    VibrationAmFmDecoderContext* pOutContext, VibrationAmFmFormat format, float baseFrequency) NN_NOEXCEPT
{
    VibrationAmFmDecoder::Reset(
        pOutContext,
        format,
        VibrationAmpFreqT::FromFloat(baseFrequency));
}

void DecodeVibrationAmFmCode(int amFmCode, VibrationAmFmDecoderContext* pContext) NN_NOEXCEPT
{
    VibrationAmFmDecoder::Decode(amFmCode, pContext);
}

void DecodeVibrationAm7bitCode(int amCode, VibrationAmFmDecoderContext* pContext) NN_NOEXCEPT
{
    VibrationAmFmDecoder::DecodeAm7bitCode(amCode, pContext);
}

void DecodeVibrationFm7bitCode(int fmCode, VibrationAmFmDecoderContext* pContext) NN_NOEXCEPT
{
    VibrationAmFmDecoder::DecodeFm7bitCode(fmCode, pContext);
}

float GetVibrationAmplitudeFromAmFmDecoder(const VibrationAmFmDecoderContext* pContext) NN_NOEXCEPT
{
    VibrationAmpFreqT::Type a = VibrationAmFmDecoder::GetAmplitude(pContext);
    return VibrationAmpFreqT::GetFloat(a);
}

float GetVibrationFrequencyFromAmFmDecoder(const VibrationAmFmDecoderContext* pContext) NN_NOEXCEPT
{
    VibrationAmpFreqT::Type f = VibrationAmFmDecoder::GetFrequency(pContext);
    return VibrationAmpFreqT::GetFloat(f);
}

void ResetVibrationAmFmEncoderContext(VibrationAmFmEncoderContext* pOutContext, float baseFrequency) NN_NOEXCEPT
{
    VibrationAmFmEncoder::Reset(
        pOutContext,
        VibrationAmpFreqT::FromFloat(baseFrequency));
}

int EncodeVibrationToAmFmCode(float amplitude, float frequency, VibrationAmFmEncoderContext* pContext) NN_NOEXCEPT
{
    return VibrationAmFmEncoder::Encode(
        VibrationAmpFreqT::FromFloat(amplitude),
        VibrationAmpFreqT::FromFloat(frequency),
        pContext);
}

int EncodeVibrationToAm7bitCode(float amplitude, VibrationAmFmEncoderContext* pContext) NN_NOEXCEPT
{
    return VibrationAmFmEncoder::EncodeToAm7bitCode(
        VibrationAmpFreqT::FromFloat(amplitude),
        pContext);
}

int EncodeVibrationToFm7bitCode(float frequency, VibrationAmFmEncoderContext* pContext) NN_NOEXCEPT
{
    return VibrationAmFmEncoder::EncodeToFm7bitCode(
        VibrationAmpFreqT::FromFloat(frequency),
        pContext);
}

}} // namespace nn::xcd
