﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/xcd/xcd_BleTypes.h>
#include "xcd_BleReportTypes.h"

namespace nn { namespace bluetooth {
struct GattAttributeUuid;
}}

namespace nn { namespace xcd {

//!< コマンドの実行結果を待ち受けるためのクラスです
class IBleCommandListener
{
    NN_DISALLOW_COPY(IBleCommandListener);
    NN_DISALLOW_MOVE(IBleCommandListener);

public:
    IBleCommandListener() NN_NOEXCEPT { /* 何もしない */ };
    virtual ~IBleCommandListener() NN_NOEXCEPT { /* 何もしない */ };

    //!< MTU の設定が完了した際の通知を受け取るための関数です
    virtual void NotifyConfigureMtuCompleted(uint16_t mtu) NN_NOEXCEPT
    {
        NN_UNUSED(mtu);
    };

    //!< Characteristic Read が完了した際の通知を受け取るための関数です
    virtual void CharacteristicReadComplete(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    {
        NN_UNUSED(uuid);
    };

    //!< Characteristic Write が完了した際の通知を受け取るための関数です
    virtual void CharacteristicWriteComplete(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    {
        NN_UNUSED(uuid);
    };

    //!< Descriptor Read が完了した際の通知を受け取るための関数です
    virtual void DescriptorReadComplete(const nn::bluetooth::GattAttributeUuid& characteristicUuid, const nn::bluetooth::GattAttributeUuid& descriptorUuid) NN_NOEXCEPT
    {
        NN_UNUSED(characteristicUuid);
        NN_UNUSED(descriptorUuid);
    };

    //!< Descriptor Write が完了した際の通知を受け取るための関数です
    virtual void DescriptorWriteComplete(const nn::bluetooth::GattAttributeUuid& characteristicUuid, const nn::bluetooth::GattAttributeUuid& descriptorUuid) NN_NOEXCEPT
    {
        NN_UNUSED(characteristicUuid);
        NN_UNUSED(descriptorUuid);
    };

    //!< Gatt 操作でエラーが発生した際の通知を受け取るための関数です
    virtual void NotifyGattOperationError(uint32_t status) NN_NOEXCEPT
    {
        NN_UNUSED(status);
    };

    //!< Ble OutputCommand の実行完了の通知を受け取るための関数です
    virtual void NotifyCommandCompleted(BleDeviceOperationType operationType, BleDeviceOperationResultType resultType) NN_NOEXCEPT
    {
        NN_UNUSED(operationType);
        NN_UNUSED(resultType);
    };

    //!< Ble OutputCommand に対して ProductType の読み込みが完了した際の通知を受け取るための関数です
    virtual void NotifyReadProductType(const BleDeviceProductType& type) NN_NOEXCEPT
    {
        NN_UNUSED(type);
    };

    //!< Ble OutputCommand に対して ModelInformation の読み込みが完了した際の通知を受け取るための関数です
    virtual void NotifyReadModelInformation(const BleDeviceModelInformation& info) NN_NOEXCEPT
    {
        NN_UNUSED(info);
    };

    //!< Ble OutputCommand に対して SensorCalibration の読み込みが完了した際の通知を受け取るための関数です
    virtual void NotifyReadSensorCalibration(const SensorCalibrationValue& value) NN_NOEXCEPT
    {
        NN_UNUSED(value);
    };

    //!< Ble OutputCommand に対して AnalogStickCalibration の読み込みが完了した際の通知を受け取るための関数です
    virtual void NotifyReadAnalogStickCalibration(const AnalogStickValidRange& value) NN_NOEXCEPT
    {
        NN_UNUSED(value);
    };

    //!< Ble OutputCommand に対して ContentUniqueCode の読み込みが完了した際の通知を受け取るための関数です
    virtual void NotifyReadContentUniqueCode(BleDeviceOperationResultType resultType, const uint8_t* buffer, size_t size) NN_NOEXCEPT
    {
        NN_UNUSED(resultType);
        NN_UNUSED(buffer);
        NN_UNUSED(size);
    };

    //!< Ble OutputCommand に対して Step の読み込みが完了した際の通知を受け取るための関数です
    virtual void NotifyReadStep(BleDeviceOperationResultType resultType, uint32_t step) NN_NOEXCEPT
    {
        NN_UNUSED(resultType);
        NN_UNUSED(step);
    };

    //!< Ble OutputCommand に対して ContentState の読み込みが完了した際の通知を受け取るための関数です
    virtual void NotifyReadContentState(BleDeviceOperationResultType resultType, bool isValid) NN_NOEXCEPT
    {
        NN_UNUSED(resultType);
        NN_UNUSED(isValid);
    };

    //!< Ble OutputCommand に対してデータベース識別バージョンの読み込みが完了した際の通知を受け取るための関数です
    virtual void NotifyReadDatabaseVersion(BleDeviceOperationResultType resultType, int32_t version) NN_NOEXCEPT
    {
        NN_UNUSED(resultType);
        NN_UNUSED(version);
    };

    //!< Ble OutputCommand に対して Application セクションからのデータ読み込みが完了した際の通知を受け取るための関数です
    virtual void NotifyReadApplicationSection(BleDeviceOperationResultType resultType, const uint8_t* buffer, int32_t size, int32_t address) NN_NOEXCEPT
    {
        NN_UNUSED(resultType);
        NN_UNUSED(buffer);
        NN_UNUSED(size);
        NN_UNUSED(address);
    };

    //!< Ble OutputCommand に対して一時停止されている FeatureSet の機能を受信した際の通知を受け取るための関数です
    virtual void NotifyRespSuspendFeatureSet(BleDeviceOperationResultType resultType, uint32_t featureFlagSet) NN_NOEXCEPT
    {
        NN_UNUSED(resultType);
        NN_UNUSED(featureFlagSet);
    };

    //!< Ble OutputCommand に対して PlayLog の読み込みが完了した際の通知を受け取るための関数です
    virtual void NotifyReadPlayLog(BleDeviceOperationResultType resultType, uint16_t index, const uint8_t* buffer, int32_t size) NN_NOEXCEPT
    {
        NN_UNUSED(resultType);
        NN_UNUSED(index);
        NN_UNUSED(buffer);
        NN_UNUSED(size);
    };
};

}} // namespace nn::xcd
