﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.xcd
{
    [CppRefPath(@"<nn/xcd/xcd_Device.h>")]
    [ExternalStruct(8, 4)]
    public struct DeviceHandle
    {
    }

    [CppRefPath(@"<nn/xcd/xcd_NfcTypes.h>")]
    [ExternalStruct(32, 4)]
    public struct McuVersionDataForNfc
    {
    }

    [CppRefPath(@"<nn/xcd/xcd_NfcTypes.h>")]
    [LargeData(true)]
    [ExternalStruct(2052, 4)]
    public struct NfcInfo
    {
    }

    [CppRefPath(@"<nn/xcd/xcd_NfcTypes.h>")]
    [ExternalStruct(8, 4)]
    public struct NfcDiscoveryParameter
    {
    }

    [CppRefPath(@"<nn/xcd/xcd_NfcTypes.h>")]
    [ExternalStruct(40, 4)]
    public struct NtagReadParameter
    {
    }

    [CppRefPath(@"<nn/xcd/xcd_NfcTypes.h>")]
    [LargeData(true)]
    [ExternalStruct(1012, 4)]
    public struct NtagWriteParameter
    {
    }

    [CppRefPath(@"<nn/xcd/xcd_NfcTypes.h>")]
    [LargeData(true)]
    [ExternalStruct(536, 4)]
    public struct NfcPassThruParameter
    {
    }

    [CppRefPath(@"<nn/xcd/xcd_NfcTypes.h>")]
    [LargeData(true)]
    [ExternalStruct(100, 4)]
    public struct MifareKeyWriteParameter
    {
    }

    [CppRefPath(@"<nn/xcd/xcd_NfcTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct MifareKeyClearParameter
    {
    }

    [CppRefPath(@"<nn/xcd/xcd_NfcTypes.h>")]
    [LargeData(true)]
    [ExternalStruct(280, 4)]
    public struct MifareReadParameter
    {
    }

    [CppRefPath(@"<nn/xcd/xcd_NfcTypes.h>")]
    [LargeData(true)]
    [ExternalStruct(536, 4)]
    public struct MifareWriteParameter
    {
    }
}

namespace nn.xcd.detail
{
    [CppRefPath(@"<nn/xcd/detail/xcd_ISystemServer.sfdl.h>")]
    public interface ISystemServer : IServiceObject
    {
        // Common API

        [MethodId(0)]
        Result GetDataFormat(
            Out<uint8_t> pOutDataFormat,
            DeviceHandle deviceHandle);

        [MethodId(1)]
        Result SetDataFormat(
            uint8_t dataFormat,
            DeviceHandle deviceHandle);

        [MethodId(2)]
        Result GetMcuState(
            Out<uint8_t> pOutMcuState,
            DeviceHandle deviceHandle);

        [MethodId(3)]
        Result SetMcuState(
            uint8_t mcuState,
            DeviceHandle deviceHandle);

        [MethodId(4)]
        Result GetMcuVersionForNfc(
            Out<McuVersionDataForNfc> pOutMcuVersionData,
            DeviceHandle deviceHandle);

        [MethodId(5)]
        Result CheckNfcDevicePower(
            DeviceHandle deviceHandle);

        [MethodId(6)]
        Result SetMcuStateImmediate(
            uint8_t mcuState,
            DeviceHandle deviceHandle);


        // NFC API

        [MethodId(10)]
        Result SetNfcEvent(
            Out<NativeHandle> nfcEventHandle,
            Out<NativeHandle> nfcDetectEventHandle,
            DeviceHandle deviceHandle);

        [MethodId(11)]
        Result GetNfcInfo(
            Out<NfcInfo> pOutValue,
            DeviceHandle deviceHandle);

        [MethodId(12)]
        Result StartNfcDiscovery(
            NfcDiscoveryParameter discoveryParameter,
            DeviceHandle deviceHandle);

        [MethodId(13)]
        Result StopNfcDiscovery(
            DeviceHandle deviceHandle);

        [MethodId(14)]
        Result StartNtagRead(
            NtagReadParameter readParameter,
            DeviceHandle deviceHandle);

        [MethodId(15)]
        Result StartNtagWrite(
            NtagWriteParameter writeParameter,
            DeviceHandle deviceHandle);

        [MethodId(16)]
        Result SendNfcRawData(
            NfcPassThruParameter passThruParameter,
            DeviceHandle deviceHandle);

        [MethodId(17)]
        Result RegisterMifareKey(
            MifareKeyWriteParameter keyWriteParameter,
            DeviceHandle deviceHandle);

        [MethodId(18)]
        Result ClearMifareKey(
            MifareKeyClearParameter keyClearParameter,
            DeviceHandle deviceHandle);

        [MethodId(19)]
        Result StartMifareRead(
            MifareReadParameter readParameter,
            DeviceHandle deviceHandle);

        [MethodId(20)]
        Result StartMifareWrite(
            MifareWriteParameter writeParameter,
            DeviceHandle deviceHandle);

        [MethodId(101)]
        Result GetAwakeTriggerReasonForLeftRail(
            Out<uint64_t> pOutParameter);

        [MethodId(102)]
        Result GetAwakeTriggerReasonForRightRail(
            Out<uint64_t> pOutParameter);
    }
}
