﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_Thread.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/bluetooth/bluetooth_Api.h>
#include "xcd_NwcpHidAccessor-os.horizon.h"

namespace nn { namespace xcd { namespace detail {


NwcpHidAccessor::NwcpHidAccessor() NN_NOEXCEPT
    : m_Activated(false)
{
    // 何もしない
}

NwcpHidAccessor::~NwcpHidAccessor() NN_NOEXCEPT
{
    // 何もしない
}

void NwcpHidAccessor::Activate(DeviceHandle deviceHandle, NwcpDriver* pDriver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(m_Activated, false);
    NN_SDK_REQUIRES_NOT_NULL(pDriver);

    m_DeviceHandle = deviceHandle;
    m_pDriver = pDriver;
    m_Activated = true;
}

void NwcpHidAccessor::Deactivate() NN_NOEXCEPT
{
    // サンプリングを中止
    StopSampling();

    // デバイスハンドルを初期化
    m_DeviceHandle = DeviceHandle::GetInvalidHandle();
    m_pDriver = nullptr;
    m_Activated = false;
}

void NwcpHidAccessor::StartSampling(InputReportParserFunc func, void* pArg) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(func);
    NN_SDK_REQUIRES_NOT_NULL(pArg);
    NN_SDK_REQUIRES_EQUAL(m_Activated, true);

    m_pDriver->SetSampleParserFunction(func, pArg);
}

void NwcpHidAccessor::StopSampling() NN_NOEXCEPT
{
    // 何もしない
}

void NwcpHidAccessor::SetOutputReport(const uint8_t* pBuffer, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pBuffer);
    NN_SDK_REQUIRES_EQUAL(m_Activated, true);

    // TODO Result ハンドリング
    m_pDriver->SetOutputReport(pBuffer, size);
}

void NwcpHidAccessor::SetReport(ReportType reportType, uint8_t* pBuffer, size_t size, IHidListener* pListener) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pBuffer);
    NN_SDK_REQUIRES_NOT_NULL(pListener);
    NN_SDK_REQUIRES_EQUAL(m_Activated, true);
    NN_SDK_REQUIRES(size > 0);
    NN_UNUSED(reportType);
    m_pDriver->SetReport(pBuffer, size, pListener);
}

void NwcpHidAccessor::GetReport(ReportType reportType, uint8_t reportId, IHidListener* pListener) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pListener);
    NN_UNUSED(reportType);
    m_pDriver->GetReport(reportId, pListener);
}

void NwcpHidAccessor::SetFirmwareUpdateModeEnabled(bool enabled) NN_NOEXCEPT
{
    m_pDriver->SetFirmwareUpdateModeEnabled(enabled);
}

void NwcpHidAccessor::SetFastModeEnabled(bool enabled) NN_NOEXCEPT
{
    m_pDriver->SetFastModeEnabled(enabled);
}

Result NwcpHidAccessor::GetInterval(::nn::TimeSpan* pOutInterval) NN_NOEXCEPT
{
    *pOutInterval = m_pDriver->GetInterval();
    NN_RESULT_SUCCESS;
}

size_t NwcpHidAccessor::GetInputReport(uint8_t* pOutValue, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_EQUAL(m_Activated, true);
    NN_SDK_REQUIRES(size > 0);

    return m_pDriver->GetInputReport(pOutValue, size);
}

void NwcpHidAccessor::DetachDevice() NN_NOEXCEPT
{
    // Nwcp ではデバイスの切断はできない
}

}}} // namespace nn::xcd::detail
