﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_EventTypes.h>
#include <nn/xcd/xcd_Device.h>

#include "../xcd_ReportTypes.h"
#include "xcd_IHidListener.h"

namespace nn { namespace xcd { namespace detail{

//!< 汎用的なHidデバイスを扱うクラス
class HidAccessor
{
public:
    HidAccessor() NN_NOEXCEPT { /* 何もしない */};
    virtual ~HidAccessor() NN_NOEXCEPT { /* 何もしない */ };

    //!< サンプリングを開始
    virtual void StartSampling(InputReportParserFunc func, void* pArg) NN_NOEXCEPT = 0;

    //!< サンプリングを停止
    virtual void StopSampling() NN_NOEXCEPT = 0;

    //!< OutputReportをセットする
    virtual void SetOutputReport(const uint8_t* pBuffer, size_t size) NN_NOEXCEPT = 0;

    //!< InputReportを読み出す
    virtual size_t GetInputReport(uint8_t* pOutValue, size_t size) NN_NOEXCEPT = 0;

    //!< SetReport を送信する
    virtual void SetReport(ReportType reportType, uint8_t* pBuffer, size_t size, IHidListener* pListener) NN_NOEXCEPT = 0;

    //!< GetReport を送信する
    virtual void GetReport(ReportType reportType, uint8_t reportId, IHidListener* pListener) NN_NOEXCEPT = 0;

    //!< 通信周期を取得する
    virtual Result GetInterval(::nn::TimeSpan* pOutInterval) NN_NOEXCEPT = 0;

    //!< デバイスを切断する
    virtual void DetachDevice() NN_NOEXCEPT = 0;

    //!< 通信モードをファームウェア更新モードにする
    virtual void SetFirmwareUpdateModeEnabled(bool enabled) NN_NOEXCEPT
    {
        NN_UNUSED(enabled);
    };

    //!< 高速通信モードを切り替える
    virtual void SetFastModeEnabled(bool enabled) NN_NOEXCEPT
    {
        NN_UNUSED(enabled);
    };
};

}}} // namespace nn::xcd::detail
