﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/xcd/detail/xcd_ISystemServer.sfdl.h>
#include "xcd_CreateSystemServer.h"
#include "xcd_SystemServerImpl.h"
#include "xcd_ServiceName.h"

namespace nn { namespace xcd { namespace detail {

namespace {

// アロケータのサイズ
const size_t AllocatorSize = 16 * 1024;

// HIPC プロキシ用の拡張ヒープを使用したアロケータ
struct CreateSystemServerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<AllocatorSize, CreateSystemServerByHipcTag> ProxyAllocator;

// ProxyAllocator を静的コンストラクタで初期化するためのヘルパー
class ProxyAllocatorInitializer
{
public:
    ProxyAllocatorInitializer() NN_NOEXCEPT
    {
        ProxyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }
} g_ProxyAllocatorInitializer;

}  // anonymous namespace

nn::sf::SharedPointer<ISystemServer> CreateSystemServerByHipc() NN_NOEXCEPT
{
    // HIPC サービスオブジェクトを作成して返す
    nn::sf::SharedPointer<ISystemServer> pServer;
    auto result = nn::sf::CreateHipcProxyByName<ISystemServer, ProxyAllocator::Policy>(
        &pServer,
        XcdSystemServiceName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    return pServer;
}

}}} // namespace nn::xcd::detail
