﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Aardvark ラッパーライブラリの API 宣言です。
 */

#pragma once

#include <nn/nn_Common.h>

#include "aardvark_Types-os.win32.h"

namespace nn { namespace xcd { namespace detail { namespace aardvark {

/**
 * @name    ポートの操作
 * @{
 */

DeviceHandle Open(int portNumber) NN_NOEXCEPT;

int Close(DeviceHandle handle) NN_NOEXCEPT;

int SetMode(DeviceHandle handle, Mode mode) NN_NOEXCEPT;

int GetMode(DeviceHandle handle) NN_NOEXCEPT;

//! @}

/**
 * @name    GPIO の操作
 * @{
 */

int SetGpioDirection(DeviceHandle handle, nn::Bit8 pinMask) NN_NOEXCEPT;

int SetGpioPullup(DeviceHandle handle, nn::Bit8 pinMask) NN_NOEXCEPT;

int GetGpioPins(DeviceHandle handle) NN_NOEXCEPT;

int SetGpioPins(DeviceHandle handle, nn::Bit8 pins) NN_NOEXCEPT;

//! @}

/**
 * @name    SPI の操作
 * @{
 */

int ConfigureSpi(DeviceHandle handle, const SpiConfig& config) NN_NOEXCEPT;

int SetSpiMode(DeviceHandle handle, SpiMode mode) NN_NOEXCEPT;

int GetSpiBitrate(DeviceHandle handle) NN_NOEXCEPT;

int SetSpiBitrate(DeviceHandle handle, int bitrateKhz) NN_NOEXCEPT;

int SetSpiMasterSsPolarity(DeviceHandle handle, SpiMasterSsPolarity polarity) NN_NOEXCEPT;

int ReadSpi(size_t* pOutDoneBytes, char* pOutReadData, size_t readDataBytes, DeviceHandle handle) NN_NOEXCEPT;

int WriteSpi(char* pOutReceivedData,
             const char* pWriteData,
             size_t transferBytes,
             DeviceHandle handle) NN_NOEXCEPT;

//! @}

}}}}
