﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/impl/sf_StaticOneAllocator.h>

#include "wlan_CreateWlanManagers.h"
#include "detail/wlan_ServiceName.h"

namespace nn { namespace wlan {
namespace {

struct CreateWlanManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<16 * 1024, CreateWlanManagerByHipcTag> MyAllocator;

class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }
};
MyAllocatorInitializer g_MyAllocatorInitializer;

}

nn::sf::SharedPointer<detail::IInfraManager> CreateInfraManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IInfraManager> accessor;
    auto result = pManager->InitializeByName<detail::IInfraManager, MyAllocator::Policy>(
                      &accessor, detail::InfraServiceName
                  );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return accessor;
}

nn::sf::SharedPointer<detail::ILocalManager> CreateLocalManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::ILocalManager> accessor;
    auto result = pManager->InitializeByName<detail::ILocalManager, MyAllocator::Policy>(
                      &accessor, detail::LocalServiceName
                  );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return accessor;
}

nn::sf::SharedPointer<detail::ISocketManager> CreateSocketManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::ISocketManager> accessor;
    auto result = pManager->InitializeByName<detail::ISocketManager, MyAllocator::Policy>(
                      &accessor, detail::SocketServiceName
                  );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return accessor;
}

nn::sf::SharedPointer<detail::ILocalGetFrame> CreateLocalGetFrameManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::ILocalGetFrame> accessor;
    auto result = pManager->InitializeByName<detail::ILocalGetFrame, MyAllocator::Policy>(
                      &accessor, detail::LocalGetFrameServiceName
                  );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return accessor;
}

nn::sf::SharedPointer<detail::ILocalGetActionFrame> CreateLocalGetActionFrameManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::ILocalGetActionFrame> accessor;
    auto result = pManager->InitializeByName<detail::ILocalGetActionFrame, MyAllocator::Policy>(
                      &accessor, detail::LocalGetActionFrameServiceName
                  );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return accessor;
}

nn::sf::SharedPointer<detail::ISocketGetFrame> CreateSocketGetFrameManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::ISocketGetFrame> accessor;
    auto result = pManager->InitializeByName<detail::ISocketGetFrame, MyAllocator::Policy>(
                      &accessor, detail::SocketGetFrameServiceName
                  );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return accessor;
}

nn::sf::SharedPointer<detail::IDetectManager> CreateDetectManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IDetectManager> accessor;
    auto result = pManager->InitializeByName<detail::IDetectManager, MyAllocator::Policy>(
                      &accessor, detail::DetectServiceName
                  );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return accessor;
}

}} // end of namespace nn::wlan

