﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_VicTaskWorker.h"

namespace nn{ namespace visrv{ namespace vic{

    VicTaskWorker g_VicTaskWorker;

    //--------------------------------------

    void VicTaskWorker::Initialize() NN_NOEXCEPT
    {
        m_TaskQueue.Initialize();
    }

    void VicTaskWorker::Finalize() NN_NOEXCEPT
    {
        m_TaskQueue.Finalize();
    }

    void VicTaskWorker::SubmitTask(IVicTask* pTask) NN_NOEXCEPT
    {
        m_TaskQueue.Enqueue(pTask);
    }

    void VicTaskWorker::Run() NN_NOEXCEPT
    {
        for(;;)
        {
            IVicTask* pTask = nullptr;
            m_TaskQueue.Dequeue(&pTask);
            NN_SDK_ASSERT_NOT_NULL(pTask);
            pTask->Execute();
        }
    }

}}}
