﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nvddk_vic.h>

namespace nn{ namespace visrv{ namespace vic{

    class VicModule
    {
    public:
        VicModule() NN_NOEXCEPT;

        nn::Result Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;
        bool IsInitialized() const NN_NOEXCEPT;

        NvRmDeviceHandle GetDevice() const NN_NOEXCEPT;
        NvDdkVicSession* GetSession() const NN_NOEXCEPT;

    private:
        NvRmDeviceHandle m_Device;
        NvDdkVicSession* m_pSession;
    };

    extern VicModule g_VicModule;

}}}
