﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/vi/vi_DisplayModeInfoInternal.h>
#include <nn/vi/vi_DisplayMode.private.h>

namespace nn { namespace visrv { namespace settings {

    enum class InterfaceType;

    class DisplayController
    {
    public:
        DisplayController() NN_NOEXCEPT;
        void Read(int id) NN_NOEXCEPT;

        int priority;

        InterfaceType interface;

        int modeCount;
        nn::vi::DisplayModeInfoInternal modes[nn::vi::DisplayModeCountMax];
    };

}}}

#if   defined(NN_BUILD_CONFIG_HARDWARE_NX)
    #include "visrv_DisplayController-hardware.nx.h"
#elif defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2)
    #include "visrv_DisplayController-hardware.jetson-tk2.h"
#else
    #error "No DC configuration defined for this hardware."
#endif
