﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace visrv { namespace settings { namespace detail {

    size_t Read(void* buffer, size_t bufferSize, const char* key) NN_NOEXCEPT;

    template <typename T>
    size_t ReadItem(T* pOutValue, const char* key) NN_NOEXCEPT
    {
        return Read(pOutValue, sizeof(T), key);
    }

    template <typename T, size_t Size>
    size_t ReadArray(T (&pOutBuffer)[Size], const char* key) NN_NOEXCEPT
    {
        return Read(pOutBuffer, Size, key);
    }

}}}}
