﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/sf/vi_DisplayService.sfdl.h>

namespace nn{ namespace visrv{ namespace service{

    class SystemRootServiceImpl
    {
    public:
        SystemRootServiceImpl() NN_NOEXCEPT;
        ~SystemRootServiceImpl() NN_NOEXCEPT;

        nn::Result GetDisplayService(
            nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService,
            nn::vi::PolicyLevelType policyLevel
            ) NN_NOEXCEPT;

        nn::Result GetDisplayServiceWithProxyNameExchange(
            nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService,
            nn::vi::PolicyLevelType policyLevel,
            nn::vi::ProxyName proxyName
            ) NN_NOEXCEPT;
    };

}}}
