﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_SystemRootServiceImpl.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/os.h>
#include <nn/vi/vi_Result.h>
#include "../visrv_Log.h"
#include "../visrv_Config.h"
#include "visrv_ApplicationDisplayServiceFactory.h"
#include "visrv_CheckPermission.h"

namespace nn{ namespace visrv{ namespace service{

    SystemRootServiceImpl::SystemRootServiceImpl() NN_NOEXCEPT
    {
        NN_VISRV_LOG_LIFETIME("SystemRootServiceImpl ctor\n");
    }
    SystemRootServiceImpl::~SystemRootServiceImpl() NN_NOEXCEPT
    {
        NN_VISRV_LOG_LIFETIME("SystemRootServiceImpl dtor\n");
    }

    namespace {

        nn::Result GetSystemDisplayServiceImpl(
            nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService,
            const client::ClientConstants& constants
        )
        {
            if(!CheckPolicyPermission(constants.GetPermission(), constants.GetPolicyLevel()))
            {
                NN_VISRV_LOG_ERR("GetSystemDisplayService failed: permission denied\n");
                NN_RESULT_THROW(nn::vi::ResultDenied());
            }

            auto p = ApplicationDisplayServiceFactory::Create(constants);
            if(p == nullptr)
            {
                NN_VISRV_LOG_ERR("GetSystemDisplayService failed: creating display service failed\n");
                NN_RESULT_THROW(nn::vi::ResultOperationFailed());
            }

            outService.Set(std::move(p));
            NN_RESULT_SUCCESS;
        }

    }

    nn::Result SystemRootServiceImpl::GetDisplayService(
        nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService,
        nn::vi::PolicyLevelType policyLevel
        ) NN_NOEXCEPT
    {
        NN_VISRV_TRACE_IPC_S(GetDisplayService);
        const client::ClientPermission clientPermission  = client::ClientPermission_System;
        client::ClientConstants constants(
            clientPermission,
            policyLevel,
            false,
            {}
        );
        return GetSystemDisplayServiceImpl(outService, constants);
    }

    nn::Result SystemRootServiceImpl::GetDisplayServiceWithProxyNameExchange(
        nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService,
        nn::vi::PolicyLevelType policyLevel,
        nn::vi::ProxyName proxyName
        ) NN_NOEXCEPT
    {
        NN_VISRV_TRACE_IPC_S(GetDisplayServiceWithProxyNameExchange);
        const client::ClientPermission clientPermission  = client::ClientPermission_System;
        client::ClientConstants constants(
            clientPermission,
            policyLevel,
            true,
            proxyName
        );
        return GetSystemDisplayServiceImpl(outService, constants);
    }


}}}
