﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_RelayServiceImpl.h"

#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include "../visrv_Config.h"
#include "../visrv_Log.h"


namespace nn{ namespace visrv{ namespace service{

    RelayServiceImpl::RelayServiceImpl(client::ClientObjectSmartHolder* pClientHolder) NN_NOEXCEPT
        : m_ClientHolder(pClientHolder)
    {
        NN_VISRV_LOG_LIFETIME("RelayServiceImpl ctor\n");
    }

    RelayServiceImpl::~RelayServiceImpl() NN_NOEXCEPT
    {
        NN_VISRV_LOG_LIFETIME("RelayServiceImpl dtor\n");
    }

    void RelayServiceImpl::TransactParcel(
        std::int32_t handle,
        std::uint32_t code,
        const nn::sf::InBuffer& requestBuffer,
        const nn::sf::OutBuffer& replyBuffer,
        std::uint32_t flags
        ) NN_NOEXCEPT
    {
        NN_VISRV_TRACE_IPCV_R(TransactParcel);
        m_ClientHolder->TransactParcel(
            handle,
            code,
            requestBuffer.GetPointerUnsafe(),
            requestBuffer.GetSize(),
            replyBuffer.GetPointerUnsafe(),
            replyBuffer.GetSize(),
            flags
        );
    }

    void RelayServiceImpl::TransactParcelAuto(
        std::int32_t handle,
        std::uint32_t code,
        const nn::sf::InBuffer& requestBuffer,
        const nn::sf::OutBuffer& replyBuffer,
        std::uint32_t flags
        ) NN_NOEXCEPT
    {
        NN_VISRV_TRACE_IPCV_R(TransactParcelAuto);
        m_ClientHolder->TransactParcel(
            handle,
            code,
            requestBuffer.GetPointerUnsafe(),
            requestBuffer.GetSize(),
            replyBuffer.GetPointerUnsafe(),
            replyBuffer.GetSize(),
            flags
        );
    }

    void RelayServiceImpl::AdjustRefcount(
        std::int32_t handle,
        std::int32_t diff,
        std::int32_t isStrong
        ) NN_NOEXCEPT
    {
        NN_VISRV_TRACE_IPCV_R(AdjustRefcount);
        m_ClientHolder->AdjustRefcount(handle, diff, isStrong);
    }

    void RelayServiceImpl::GetNativeHandle(
        std::int32_t handle,
        std::uint32_t code,
        nn::sf::Out<nn::sf::NativeHandle> result
        ) NN_NOEXCEPT
    {
        NN_VISRV_TRACE_IPCV_R(GetNativeHandle);
        m_ClientHolder->GetNativeHandle(handle, code, result);
    }

}}}

