﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace visrv{ namespace native{

    enum WriteSurfaceSourceOption : uint32_t
    {
        WriteSurfaceSourceOption_None  = 0,
        WriteSurfaceSourceOption_FlipY = (1 << 0),
    };

    enum WriteSurfaceDestinationOption : uint32_t
    {
        WriteSurfaceDestinationOption_None             = 0,
        WriteSurfaceDestinationOption_PreMultipleAlpha = (1 << 0),
        WriteSurfaceDestinationOption_Opaque           = (1 << 1),
        WriteSurfaceDestinationOption_FlipY            = (1 << 2),
    };

    nn::Result ReadFromSurfaceBlockLinearRgba8(
        void* pDestinationBuffer,
        size_t destinationSize,
        const void* pSourceBuffer,
        int targetPosX,
        int targetPosY,
        int targetWidth,
        int targetHeight,
        uint32_t pitch,
        uint32_t blockHeightLog2
    ) NN_NOEXCEPT;

    // targetPos は dest 上の座標で指定する
    nn::Result WriteToSurfaceBlockLinearRgba8(
        void* pDestinationBuffer,
        size_t destinationSize,
        uint32_t destWidth,
        uint32_t destHeight,
        const void* pSourceBuffer,
        size_t sourceBufferSize,
        int targetPosX,
        int targetPosY,
        int targetWidth,
        int targetHeight,
        uint32_t pitch,
        uint32_t blockHeightLog2,
        WriteSurfaceDestinationOption dstOption,
        WriteSurfaceSourceOption      srcOption
    ) NN_NOEXCEPT;

    nn::Result FillSurfaceRgba8(
        void* pDestinationBuffer,
        size_t destinationSize,
        uint32_t color,
        WriteSurfaceDestinationOption dstOption
    ) NN_NOEXCEPT;

}}}
