﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_Policies.h"

#include <new>
#include <limits>
#include <nn/nn_SdkAssert.h>
#include <nn/vi/vi_DisplayModeInfo.h>
#include "../../visrv_Config.h"
#include "visrv_DisplaySupport.h"
#include "visrv_PlatformDisplayInfo.h"
#include "visrv_PlatformDisplayDefines.h"

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    int SetupCompositionPolicy(PlatformDisplayInfo* pOutDisplays, int displayCountMax) NN_NOEXCEPT
    {
        DisplaySupport support;
        support.queryScalingModeSupport = ScalingModeSupport;

        // need room for at least this many policies
        const int NamedDisplayCount = 5;
        NN_SDK_ASSERT(displayCountMax >= NamedDisplayCount);

        PlatformDisplayInfo* block = pOutDisplays;

        new (block++) PlatformDisplayInfo(DefaultDisplayName,
                                          1920,
                                          1080,
                                          DisplayPolicy(true,     // hasLayerLimit
                                                        2,        // layerCountMax
                                                        0, // zOrderMin
                                                        255), // zOrderMax
                                          support,
                                          true);

        new (block++) PlatformDisplayInfo(ExternalDisplayName,
                                          1920,
                                          1080,
                                          DisplayPolicy(true,
                                                        0,
                                                        0,
                                                        0),
                                          support,
                                          false);

        new (block++) PlatformDisplayInfo(EdidDisplayName,
                                          0,
                                          0,
                                          DisplayPolicy(true,
                                                        0,
                                                        0,
                                                        0),
                                          support,
                                          false);

        new (block++) PlatformDisplayInfo(InternalDisplayName,
                                          1920,
                                          1080,
                                          DisplayPolicy(true,
                                                        0,
                                                        0,
                                                        0),
                                          support,
                                          false);

        new (block++) PlatformDisplayInfo(NullDisplayName,
                                          0,
                                          0,
                                          DisplayPolicy(true,
                                                        0,
                                                        0,
                                                        0),
                                          support,
                                          false);

        return NamedDisplayCount;
    }

    int SetupStandardPolicy(PlatformDisplayInfo* pOutDisplays, int displayCountMax) NN_NOEXCEPT
    {
        DisplaySupport support;
        support.queryScalingModeSupport = ScalingModeSupport;

        // need room for at least this many policies
        const int NamedDisplayCount = 1;
        NN_SDK_ASSERT(displayCountMax >= NamedDisplayCount);

        // TODO: process policy
        new (pOutDisplays) PlatformDisplayInfo(DefaultDisplayName,
                                               1920,
                                               1080,
                                               DisplayPolicy(true,
                                                             1,
                                                             0,
                                                             0),
                                               support,
                                               true);

        return NamedDisplayCount;
    }

}}}}
