﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "visrv_AndroidDisplay.h"

namespace nn { namespace visrv { namespace master { namespace detail {

    class LcdDisplay : public AndroidDisplay
    {
    public:
        explicit LcdDisplay(const IModeFilter* pFilter) NN_NOEXCEPT;

        virtual nn::Result GetHotplugState(nn::vi::HotplugStateType* pOutState) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetUnderscan(int underscan) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT NN_OVERRIDE;

        virtual bool IsHotplugEventSupported() const NN_NOEXCEPT NN_OVERRIDE;
        virtual bool IsVsyncEventSupported() const NN_NOEXCEPT NN_OVERRIDE;
        virtual bool IsModeChangedEventSupported() const NN_NOEXCEPT NN_OVERRIDE;

        virtual int ListRgbRanges(nn::vi::RgbRangeType* pOutRanges, int rgbCountMax) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetRgbRange(nn::vi::RgbRange range) NN_NOEXCEPT NN_OVERRIDE;
    };

}}}}
