﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/edid.h>
#include <nn/vi/vi_Result.h>
#include <hos/nvdisp_devctls.h>
#include "visrv_HdmiDisplay.h"
#include "visrv_Nvdc.h"

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    HdmiDisplay::HdmiDisplay(const IModeFilter* pFilter) NN_NOEXCEPT
        : ExternalDisplay(pFilter)
    {
    }

    nn::Result HdmiDisplay::GetHotplugState(nn::vi::HotplugStateType* pOutState) const NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pOutState);
        NN_RESULT_DO(nvdc::GetConnectionState(pOutState, NVDC_HDMI));
        NN_RESULT_SUCCESS;
    }

}}}}
