﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "visrv_AndroidDisplay.h"

namespace nn { namespace visrv { namespace master { namespace detail {

    class ExternalDisplay : public AndroidDisplay
    {
    public:
        explicit ExternalDisplay(const IModeFilter* pFilter) NN_NOEXCEPT;

        virtual bool IsHotplugEventSupported() const NN_NOEXCEPT NN_OVERRIDE;
        virtual bool IsVsyncEventSupported() const NN_NOEXCEPT NN_OVERRIDE;
        virtual bool IsModeChangedEventSupported() const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetHotplugState(nn::vi::HotplugStateType* pOutState) const NN_NOEXCEPT NN_OVERRIDE = 0;

        virtual int ListRgbRanges(nn::vi::RgbRangeType* pOutRanges, int rgbCountMax) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetRgbRange(nn::vi::RgbRange range) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetPowerState(nn::vi::PowerState state) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetMode(const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT NN_OVERRIDE;

        static nn::os::SystemEvent* GetModeChangedEvent() NN_NOEXCEPT;
    private:
        bool IsRgbQuantizationSelectable() const NN_NOEXCEPT;

        static nn::os::SystemEvent g_ModeChangedEvent;
    };

}}}}
