﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/edid.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/vi/vi_StereoMode.h>

namespace nn { namespace vi {
    struct DisplayModeInfoInternal;
}}

namespace nn { namespace visrv { namespace master { namespace detail {

    bool ConvertAspectRatio(nn::vi::AspectRatio* pOutRatio, float ratio) NN_NOEXCEPT;
    bool ConvertStereoMode(nn::vi::StereoModeType* pOutMode, nn::edid::StereoMode mode) NN_NOEXCEPT;
    bool ConvertDisplayMode(nn::vi::DisplayModeInfoInternal* pOutMode, const nn::edid::DisplayModeInfo* pMode) NN_NOEXCEPT;

}}}}
