﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nvnflinger_service.h>
#include <nn/vi/vi_CmuMode.h>
#include <nn/vi/vi_ScalingMode.h>
#include <nn/vi/vi_PowerState.h>
#include <nn/vi/vi_RgbRange.h>
#include <nn/vi/vi_AspectRatio.h>
#include <nn/vi/vi_DisplayError.h>

namespace nn{ namespace vi {
    struct DisplayModeInfo;
    struct DisplayModeInfoInternal;
}}

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    /**
     * @brief Converts to Android scaling mode format.
     *
     * @param[in] mode Scaling mode.
     *
     * @return Android scaling mode format.
     *
     * @pre  @a mode is a valid nn::vi::ScalingMode.
     * @post Android equivalent is returned.
     */
    int ConvertScalingMode(nn::vi::ScalingMode mode) NN_NOEXCEPT;

    void ConvertDisplayMode(nn::vi::DisplayModeInfo* pOutInfo, const android::DisplayInfo& info) NN_NOEXCEPT;
    bool ConvertDisplayMode(nn::vi::DisplayModeInfoInternal* pOutInfo, const android::DisplayInfo& info) NN_NOEXCEPT;

    bool ConvertRgbRangeToVi(nn::vi::RgbRange* pOutRange, int range) NN_NOEXCEPT;
    int ConvertRgbRangeToAndroid(nn::vi::RgbRange range) NN_NOEXCEPT;

    int ConvertPowerState(nn::vi::PowerState state) NN_NOEXCEPT;

    uint32_t ConvertLayerSettings(nn::vi::LayerSettings settings) NN_NOEXCEPT;

    DisplayCMUMode ConvertCmuMode(nn::vi::CmuMode mode) NN_NOEXCEPT;
    bool ConvertCmuMode(nn::vi::CmuMode* pOutMode, DisplayCMUMode mode) NN_NOEXCEPT;

    bool ConvertAspectRatio(nn::vi::AspectRatio* pOutRatio, const android::DisplayInfo& info) NN_NOEXCEPT;

    bool operator==(const nn::vi::DisplayModeInfo& viInfo, const android::DisplayInfo& androidInfo) NN_NOEXCEPT;
    bool operator==(const android::DisplayInfo& androidInfo, const nn::vi::DisplayModeInfo& viInfo) NN_NOEXCEPT;

}}}}


