﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/vi/fbshare/vi_SharedBufferHandle.h>
#include <nn/vi/fbshare/vi_SharedMemoryPoolLayout.h>
#include "../native/visrv_NativeType.h"

namespace nn{ namespace visrv{ namespace local{

    void EnqueueLocalRequestAsync(void (*function)(void*), void* userPtr) NN_NOEXCEPT;
    nn::Result EnqueueLocalRequestSync(nn::Result (*function)(void*), void* userPtr) NN_NOEXCEPT;

    template<typename Func>
    nn::Result EnqueueLocalRequestSync(Func func) NN_NOEXCEPT
    {
        return EnqueueLocalRequestSync(
            [](void* p) -> nn::Result
            {
                auto pFunc = reinterpret_cast<Func*>(p);
                return pFunc->operator()();
            },
            &func
       );
    }

    nn::Result GetSharedMemoryPoolInfo(
        NvRmMemHandle* pOutMemHandle,
        void** pOutMemory,
        size_t* pOutMemorySize,
        nn::vi::fbshare::SharedMemoryPoolLayout* pOutLayout,
        nn::vi::fbshare::SharedBufferHandle hBuffer
    ) NN_NOEXCEPT;

}}}
