﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/vi/vi_CropRegion.h>
#include <nn/vi/vi_ImageTransform.h>
#include <nn/vi/vi_LayerStack.h>
#include "../native/visrv_NativeType.h"

namespace nn{ namespace visrv{ namespace local{

    class ILocalLayer
    {
    public:
        virtual ~ILocalLayer() NN_NOEXCEPT
        {
        }

        virtual uint64_t   GetLayerResourceId() const NN_NOEXCEPT = 0;
        virtual nn::Result Connect() NN_NOEXCEPT = 0;
        virtual nn::Result Disconnect() NN_NOEXCEPT = 0;
        virtual nn::Result SetBufferCount(int count) NN_NOEXCEPT = 0;
        virtual nn::Result SetBuffer(int index, const android::sp<android::GraphicBuffer>& pBuffer) NN_NOEXCEPT = 0;
        virtual nn::Result RequestBuffer(int index) NN_NOEXCEPT = 0;
        virtual nn::Result Present(int index, const android::sp<android::Fence>& fence, const nn::vi::CropRegion& crop, int scalingMode, nn::vi::ImageTransformType transform, int presentInterval) NN_NOEXCEPT = 0;
        virtual nn::Result Acquire(int* pOutIndex, android::sp<android::Fence>* pOutFence, int expectedWidth, int expectedHeight) NN_NOEXCEPT = 0;
        virtual nn::Result GetAcquirableEvent(nn::os::SystemEventType* pOutValue) NN_NOEXCEPT = 0;
        virtual nn::Result SetLayerStackFlags(nn::vi::LayerStackFlagType stacks) NN_NOEXCEPT = 0;
        virtual nn::Result GetLayerStackFlags(nn::vi::LayerStackFlagType* pOutStacks) NN_NOEXCEPT = 0;
    };

}}}
