﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include "../visrv_Config.h"

namespace nn{ namespace visrv{ namespace indirect{

    class IndirectLayer;

    class IndirectFlipEntry
    {
    public:
        IndirectFlipEntry() NN_NOEXCEPT;

        void Initialize(int index, IndirectLayer* pLayer) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;
        bool IsStarted() const NN_NOEXCEPT;

        // 既にスタートしていたら nullptr を返す。
        // タイマーを開始する。
        // スタート状態になる。
        // 返り値が非 nullptr の場合、必ず MultiWait にリンクすること。
        nn::os::MultiWaitHolderType* Start() NN_NOEXCEPT;

        // キャンセルする。
        // MultiWait から解除される。
        // タイマーを停止する。
        // イベントがクリアされる。
        // スタート状態を解除する。
        void Stop() NN_NOEXCEPT;

        // pLayer を Flip する。
        // イベントがクリアされる。
        // スタート状態を解除する。
        void Flip() NN_NOEXCEPT;

    private:
        IndirectLayer*              m_pLayer;
        nn::os::TimerEventType      m_TimerEvent;
        nn::os::MultiWaitHolderType m_TimerHolder;
        bool                        m_IsStarted;
    };

    class IndirectFlipManager
    {
    public:
        IndirectFlipManager() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        int Register(IndirectLayer* pLayer) NN_NOEXCEPT;
        void Unregister(int index) NN_NOEXCEPT;

        void ProcessVsync() NN_NOEXCEPT;
        void ProcessSignal(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT;

    private:
        IndirectFlipEntry m_EntryList[IndirectLayerCountMax];
    };

    extern IndirectFlipManager g_IndirectFlipManager;
}}}
