﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_IndirectDisplay.h"

#include <nn/nn_SdkAssert.h>
#include <nn/util/util_ScopeExit.h>

#include <nn/vi/vi_Result.h>
#include <nn/vi/vi_ResultPrivate.h>

namespace nn{ namespace visrv{ namespace indirect{

    IndirectDisplay g_IndirectDisplay;

    void IndirectDisplay::Initialize() NN_NOEXCEPT
    {
        m_IsInitialized = true;
    }

    void IndirectDisplay::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(m_IsInitialized);
        m_IsInitialized = false;
    }

    IndirectLayer* IndirectDisplay::GetLayer(IndirectLayerIndex index) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(index, 0, IndirectLayerCountMax);
        return &m_LayerList[index];
    }

}}}
