﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_InitializeSharingServer.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include "visrv_SharingServerObject.h"
#include "../visrv_ServerManager.h"

namespace nn{ namespace visrv{ namespace fbshare{

    void InitializeSharingServer() NN_NOEXCEPT
    {
        g_Device.Initialize();
        g_GrAlloc.Initialize();
        g_SharedBufferPool.Initialize();
        g_SharedLowLevelLayerManager.Initialize();
        g_SharedClientLayerManager.Initialize(&g_ServerManager);
    }

    void FinalizeSharingServer() NN_NOEXCEPT
    {
        g_SharedClientLayerManager.Finalize();
        g_SharedLowLevelLayerManager.Finalize();
        g_SharedBufferPool.Finalize();
        g_GrAlloc.Finalize();
        g_Device.Finalize();
    }

}}}

