﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../../visrv_Config.h"
#include "visrv_TArrayPool.h"
#include "visrv_SharedClientLayer.h"

namespace nn{ namespace visrv{
    class ServerManager;
}}

namespace nn{ namespace visrv{ namespace fbshare{ namespace detail{

    class SharedClientLayerManager
    {
    public:
        static const int Size = SharedClientLayerCountMax;
        static const uintptr_t MultiWaitTagMin = MultiWaitIndex_SharedClientLayerMin;
        static const uintptr_t MultiWaitTagMax = MultiWaitIndex_SharedClientLayerMax;

    private:
        class SharedClientLayerPool
            : public TArrayPool<SharedClientLayer, Size>
        {
        public:
            nn::Result Find(SharedClientLayer** pOutValue, nn::vi::fbshare::SharedLayerHandle h) NN_NOEXCEPT;
        };

    public:
        SharedClientLayerManager() NN_NOEXCEPT;

        void Initialize(ServerManager* pServerManager) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        // OwnerClient を変更しない。 OwnerClient へのレイヤの所有権の登録は別途行うこと。
        nn::Result Create(
            SharedClientLayer** pOutLayer,
            client::ClientObject* pOwnerClient,
            nn::applet::AppletResourceUserId userAruid
        ) NN_NOEXCEPT;

        // OwnerClient を変更しない。 OwnerClient からのレイヤの所有権の解除は別途行うこと。
        void Destroy(SharedClientLayer* pLayer) NN_NOEXCEPT;

        nn::Result Find(SharedClientLayer** pOutValue, nn::vi::fbshare::SharedLayerHandle h) NN_NOEXCEPT;

        void HandleMultiWait(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT;

    private:
        ServerManager*        m_pServerManager;
        SharedClientLayerPool m_LayerPool;
    };

}}}}
