﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_ClientUtility.h"

#include <nn/util/util_StringUtil.h>
#include "visrv_LayerPool.h"

namespace nn{ namespace visrv{ namespace client{

    ClientDisplayHolder* ClientUtility::LookupDisplayHolder(
        ClientDisplayHolderList* pList,
        nn::vi::DisplayId displayId
        ) NN_NOEXCEPT
    {
        auto it = std::find_if(
            pList->begin(),
            pList->end(),
            [displayId](const ClientDisplayHolder& v) -> bool
            {
                return v.displayId == displayId;
            }
        );

        if(it == pList->end())
        {
            return nullptr;
        }

        return &*it;
    }

    ClientDisplayHolder* ClientUtility::LookupDisplayHolderByName(
        ClientDisplayHolderList* pList,
        const char* name
        ) NN_NOEXCEPT
    {
        auto it = std::find_if(
            pList->begin(),
            pList->end(),
            [name](const ClientDisplayHolder& v) -> bool
            {
                return (nn::util::Strncmp(v.name.value, name, sizeof(nn::vi::DisplayName)) == 0);
            }
        );

        if(it == pList->end())
        {
            return nullptr;
        }

        return &*it;
    }

    ClientLayerHolder* ClientUtility::LookupLayerHolderOnClient(
        ClientLayerHolderOnClientList* pList,
        ClientObject* pClient,
        nn::vi::LayerId layerId
        ) NN_NOEXCEPT
    {
        const auto permission = ClientObjectAccessor::GetConstants(pClient)->GetPermission();

        if(permission == ClientPermission_Manager)
        {
            // find from global list
            auto it = std::find_if(
                g_LayerPool.begin(),
                g_LayerPool.end(),
                [layerId](const ClientLayerHolder& v) -> bool
                {
                    return
                        (v.state != ClientLayerHolderState_Empty) &&
                        (v.layerId == layerId)
                        ;
                }
            );

            if(it == g_LayerPool.end())
            {
                return nullptr;
            }

            return &*it;
        }
        else
        {
            // find from on-client list
            auto it = std::find_if(
                pList->begin(),
                pList->end(),
                [layerId](const ClientLayerHolder& v) -> bool
                {
                    return v.layerId == layerId;
                }
            );

            if(it == pList->end())
            {
                return nullptr;
            }

            return &*it;
        }
    }

}}}
