﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/vi/vi_PixelFormat.h>
#include <nn/vi/vi_ScalingMode.h>
#include <nn/vi/vi_Types.h>
#include <nn/vi/vi_LayerSettings.h>
#include "detail/vi_Windows.h"

namespace nn { namespace vi {

    class Layer
    {
    public:
        explicit Layer(Display* pDisplay) NN_NOEXCEPT;
        ~Layer() NN_NOEXCEPT;

        nn::Result Initialize(int width, int height, PixelFormat format, LayerSettings settings) NN_NOEXCEPT;

        nn::Result SetPosition(float x, float y) NN_NOEXCEPT;
        nn::Result SetZ(int z) NN_NOEXCEPT;
        nn::Result SetScalingMode(ScalingMode mode) NN_NOEXCEPT;
        nn::Result SetSize(int width, int height) NN_NOEXCEPT;
        nn::Result SetVisibility(bool isVisible) NN_NOEXCEPT;
        nn::Result SetAlpha(float alpha) NN_NOEXCEPT;

        float GetX() const NN_NOEXCEPT;
        float GetY() const NN_NOEXCEPT;
        int GetZ() const NN_NOEXCEPT;
        int GetCurrentWidth() const NN_NOEXCEPT;
        int GetCurrentHeight() const NN_NOEXCEPT;
        NativeWindowHandle GetNativeWindow() const NN_NOEXCEPT;
        Display* GetDisplay() const NN_NOEXCEPT;

        nn::util::IntrusiveListNode m_ListNode;
    private:
        Display* m_pDisplay;
        HWND m_Window;
    };

}}
