﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/vi/vi_DisplayMode.private.h>
#include "detail/vi_Common.h"
#include "vi_Display.h"

int nn::vi::ListDisplayModes(DisplayModeInfo* pOutModes, int modeCountMax, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES(modeCountMax >= 0);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->ListModes(pOutModes, modeCountMax);
}

int nn::vi::ListDisplayRgbRanges(RgbRange* pOutRanges, int rgbCountMax, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES(rgbCountMax >= 0);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->ListRgbRanges(pOutRanges, rgbCountMax);
}

int nn::vi::ListDisplayContentTypes(ContentType* pOutTypes, int contentTypeCountMax, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES(contentTypeCountMax >= 0);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    NN_UNUSED(pOutTypes);
    NN_UNUSED(contentTypeCountMax);
    NN_UNUSED(pDisplay);

    return 0;
}

nn::Result nn::vi::GetDisplayMode(DisplayModeInfo* pOutMode, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutMode);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->GetMode(pOutMode);
}

nn::Result nn::vi::SetDisplayMode(Display* pDisplay, const DisplayModeInfo* pMode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pMode);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->SetMode(pMode);
}

nn::Result nn::vi::GetDisplayUnderscan(int* pOutUnderscan, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutUnderscan);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->GetUnderscan(pOutUnderscan);
}

nn::Result nn::vi::SetDisplayUnderscan(Display* pDisplay, int underscan) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->SetUnderscan(underscan);
}

nn::Result nn::vi::GetDisplayContentType(ContentType* pOutType, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutType);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    NN_UNUSED(pOutType);
    NN_UNUSED(pDisplay);

    return nn::ResultSuccess();
}

nn::Result nn::vi::SetDisplayContentType(Display* pDisplay, ContentType type) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    NN_UNUSED(pDisplay);
    NN_UNUSED(type);

    return nn::ResultSuccess();
}

nn::Result nn::vi::GetDisplayRgbRange(RgbRange* pOutRange, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutRange);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->GetRgbRange(pOutRange);
}

nn::Result nn::vi::SetDisplayRgbRange(Display* pDisplay, RgbRange range) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->SetRgbRange(range);
}
