﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <nn/nn_SdkAssert.h>
#include <nn/vi/vi_DisplayModeInfo.h>
#include <nn/vi/vi_DisplayMode.private.h>
#include "vi_Policies.h"
#include "vi_PlatformDisplayInfo.h"
#include "vi_PlatformDisplayDefines.h"

int nn::vi::detail::SetupStandardPolicy(PlatformDisplayInfo* pOutDisplays, int displayCountMax)
{
    NN_UNUSED(displayCountMax);

    DisplaySupport support;
    support.queryPixelFormatSupport = PixelFormatSupport;
    support.queryScalingModeSupport = ScalingModeSupport;

    DisplayModeInfo modes[] =
    {
        {
            720,
            480,
            60,
            StereoMode_None
        },

        {
            1280,
            720,
            60,
            StereoMode_None
        },

        {
            1920,
            1080,
            60,
            StereoMode_None
        },
    };

    const int modeCount = sizeof(modes) / sizeof(modes[0]);
    NN_STATIC_ASSERT(modeCount < DisplayModeCountMax);

    // need room for at least this many policies
    const int NamedDisplayCount = 1;
    NN_SDK_ASSERT(displayCountMax >= NamedDisplayCount);

    // TODO: process policy
    new (pOutDisplays) PlatformDisplayInfo(DefaultDisplayName,
                                           1920,
                                           1080,
                                           DisplayPolicy(true,
                                                         1,
                                                         0,
                                                         0,
                                                         modes,
                                                         modeCount),
                                           support,
                                           true);

    return NamedDisplayCount;
}
