﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include "vi_DisplayManager.h"
#include "vi_PlatformDisplayInfo.h"
#include "vi_PlatformDisplayDefines.h"

// Note: This can be useful for debugging segment sizes:
//       Print<sizeof(g_Padding)>() will print a compile error with the evaluated expression.
//template <size_t i>
//class Print;

// TODO: Find an appropriate size
const size_t StorageMax    = 16384;
// Storage size for any global variables
const size_t GlobalStorage = sizeof(nn::vi::detail::DisplayManager*);

typedef nn::util::TypedStorage<nn::vi::detail::DisplayManager,
                               sizeof(nn::vi::detail::DisplayManager),
                               NN_ALIGNOF(nn::vi::detail::DisplayManager)>
        DisplayManagerStorageType;
extern DisplayManagerStorageType g_DisplayManagerStorage;

// Maximum memory (in bytes) for named displays
const size_t DisplayInfoSegmentSize = nn::vi::detail::PlatformDisplayCount * sizeof(nn::vi::detail::PlatformDisplayInfo);
// Maximum memory (in bytes) for open displays
const size_t DisplaySegmentSize     = 4096;
// Maximum memory (in bytes) for layers created by the process
const size_t LayerSegmentSize       = 1024;

extern char g_DisplayInfoSegment[DisplayInfoSegmentSize];
extern char g_DisplaySegment[DisplaySegmentSize];
extern char g_LayerSegment[LayerSegmentSize];

#if defined(NN_BUILD_CONFIG_OS_WIN)
    #include "vi_MemoryMap-os.win32.h"
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include "vi_MemoryMap-os.horizon.h"
#endif
