﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/vi/vi_DisplayModeInfo.h>
#include <nn/vi/vi_DisplayMode.private.h>

namespace nn { namespace vi { namespace detail {

    class DisplayPolicy
    {
    public:
        DisplayPolicy(bool hasLayerLimit,
                      int layerCountMax,
                      int zOrderCountMin,
                      int zOrderCountMax,
                      const DisplayModeInfo* pModes,
                      int modeCount) NN_NOEXCEPT;

        bool HasLayerLimit() const NN_NOEXCEPT;
        int GetLayerCountMax() const NN_NOEXCEPT;

        int GetZOrderCountMin() const NN_NOEXCEPT;
        int GetZOrderCountMax() const NN_NOEXCEPT;

        const DisplayModeInfo* GetValidModes() const NN_NOEXCEPT;
        int GetValidModeCount() const NN_NOEXCEPT;
    private:
        DisplayModeInfo m_Modes[DisplayModeCountMax];
        int m_ModeCount;
        int m_ZOrderCountMin;
        int m_ZOrderCountMax;
        int m_LayerCountMax;
        bool m_HasLayerLimit;
    };

}}}
